/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.AbstractAction2;
import edu.princeton.swing.ClipboardTargetManager;
import edu.princeton.swing.PHighlightedTextArea;
import edu.princeton.swing.PTree;
import edu.princeton.swing.text.AutoCompleter;
import edu.princeton.swing.text.HighlightStyle;
import edu.princeton.swing.text.IndentingAutoCompleter;
import edu.princeton.toy.TCommentingAutoCompleter;
import edu.princeton.toy.TConfigurationManager;
import edu.princeton.toy.TFrame;
import edu.princeton.toy.TMain;
import edu.princeton.toy.TUncommentingAutoCompleter;
import edu.princeton.toy.choosers.TCheckingChooserPane;
import edu.princeton.toy.choosers.TColorChooserPane;
import edu.princeton.toy.choosers.TExceptionChooserPane;
import edu.princeton.toy.choosers.TFontChooserPane;
import edu.princeton.toy.choosers.TPerformanceChooserPane;
import edu.princeton.toy.choosers.TStyleChooserPane;
import edu.princeton.toy.lang.TDefaultExceptionHandler;
import edu.princeton.toy.lang.TExceptionHandler;
import edu.princeton.toy.lang.TWord;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TOptionsFrame
extends JFrame
implements ActionListener,
TreeSelectionListener {
    public static final int WIDTH = 640;
    public static final int HEIGHT = 460;
    private static final String CLASS_STRING;
    public static final String OK_COMMAND;
    public static final String CANCEL_COMMAND;
    public static final String DEFAULTS_COMMAND;
    public static final String APPLY_COMMAND;
    public static final DefaultMutableTreeNode ROOT_NODE;
    public static final DefaultMutableTreeNode EDITING_NODE;
    public static final DefaultMutableTreeNode EDITING_FONTS_NODE;
    public static final DefaultMutableTreeNode EDITING_COLORS_NODE;
    public static final DefaultMutableTreeNode EDITING_HIGHLIGHTING_NODE;
    public static final DefaultMutableTreeNode EDITING_CHECKING_NODE;
    public static final DefaultMutableTreeNode EXECUTION_NODE;
    public static final DefaultMutableTreeNode EXECUTION_EXCEPTION_NODE;
    public static final DefaultMutableTreeNode EXECUTION_PERFORMANCE_NODE;
    public static final String[] FONT_AREA_NAMES;
    public static final String[] FONT_AREA_KEYS;
    public static final int PROGRAM_AREA_INDEX = 0;
    public static final int WARNING_AREA_INDEX = 1;
    public static final int REFERENCE_AREA_INDEX = 2;
    public static final int STDIN_AREA_INDEX = 3;
    public static final int STDOUT_AREA_INDEX = 4;
    public static final int CORE_AREA_INDEX = 5;
    public static final String[] COLOR_NAMES;
    public static final String[] COLOR_DISABLED_DESCRIPTIONS;
    public static final String[] COLOR_COLOR_KEYS;
    public static final String[] COLOR_DISABLED_KEYS;
    public static final int FOREGROUND_COLOR_INDEX = 0;
    public static final int BACKGROUND_COLOR_INDEX = 1;
    public static final int CARET_COLOR_INDEX = 2;
    public static final int SELECTION_COLOR_INDEX = 3;
    public static final int SELECTED_TEXT_COLOR_INDEX = 4;
    public static final int HIGHLIGHTED_LINE_COLOR_INDEX = 5;
    public static final int HIGHLIGHTED_TEXT_COLOR_INDEX = 6;
    public static final int LINE_NUMBERS_COLOR_INDEX = 7;
    public static final int COLUMN_MARKERS_COLOR_INDEX = 8;
    public static final String[] HIGHLIGHT_STYLE_NAMES;
    public static final String[] HIGHLIGHT_STYLE_KEYS;
    public static final AutoCompleter[] AUTO_COMPLETERS;
    public static final String AUTO_COMPLETER_KEY = "toy.editing.autoComplete#autoCompleter";
    public static final String IGNORE_WARNINGS_KEY = "toy.editing.checking#ignoreWarnings";
    public static final String AUTO_CHECK_KEY = "toy.editing.checking#autoCheck";
    public static final String[] EXCEPTION_TYPE_KEYS;
    public static final String CLOCK_PERIOD_KEY = "toy.execution.performance#clockPeriod";
    public static final int[] CLOCK_PERIODS;
    public static final String REFRESH_RATE_KEY = "toy.execution.performance#refreshRate";
    public static final int[] REFRESH_RATES;
    private static final Toolkit TOOLKIT;
    public static final AbstractAction2 OPTIONS_ACTION;
    public static final int FILE_HISTORY_SIZE = 6;
    public static final AbstractAction2[] FILE_HISTORY_ACTIONS;
    public static final String[] FILE_HISTORY_KEYS;
    public static final String CURRENT_DIRECTORY_KEY = "toy.autogenerate.filesystem#currentDirectory";
    public static final String LAST_FRAME_BOUNDS_KEY = "toy.autogenerate.toyFrame#bounds";
    public static final String LAST_VERTICAL_DIVIDER_LOCATION_KEY = "toy.autogenerate.toyFrame#verticalDividerLocation";
    public static final String LAST_EDIT_HORIZONTAL_DIVIDER_LOCATION_KEY = "toy.autogenerate.toyFrame.editPane#horizontalDividerLocation";
    public static final String LAST_SIM_HORIZONTAL_DIVIDER_LOCATION_KEY = "toy.autogenerate.toyFrame.simPane#horizontalDividerLocation";
    public static final String LAST_OPTIONS_FRAME_POSITION_KEY = "toy.autogenerate.optionsFrame#position";
    private static final Object NULL_OBJECT;
    private static final Hashtable DEFAULT_OPTIONS;
    private static final Dimension INITIAL_SCREEN_SIZE;
    private static final TOptionsFrame INSTANCE;
    private File currentDirectory;
    private File[] fileHistory;
    private boolean ignoreWarnings;
    private boolean autoCheck;
    private IntStruct clockPeriod;
    private Document clockPeriodDocument;
    private IntStruct refreshRate;
    private Document refreshRateDocument;
    private TDefaultExceptionHandler exceptionHandler;
    private PTree tree;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private TFontChooserPane editingFontsPane;
    private TColorChooserPane editingColorsPane;
    private TStyleChooserPane editingHighlightingPane;
    private TCheckingChooserPane editingCheckingPane;
    private TExceptionChooserPane executionExceptionPane;
    private TPerformanceChooserPane executionPerformancePane;
    private Hashtable appliedOptions;
    private Vector[] areaComponents;
    private Vector highlightedTextAreas;
    private Rectangle lastFrameBounds;
    private IntStruct lastVerticalDividerLocation;
    private IntStruct lastEditHorizontalDividerLocation;
    private IntStruct lastSimHorizontalDividerLocation;
    private Point lastOptionsFramePosition;

    private TOptionsFrame() {
        super("Visual X-TOY Options");
        int ctr;
        int commaIndex;
        File tempFile;
        this.setIconImage(TMain.getFrameIcon());
        this.clockPeriodDocument = new PlainDocument();
        this.refreshRateDocument = new PlainDocument();
        this.exceptionHandler = new TDefaultExceptionHandler();
        this.appliedOptions = new Hashtable();
        this.areaComponents = new Vector[FONT_AREA_NAMES.length];
        for (int ctr2 = 0; ctr2 < FONT_AREA_NAMES.length; ++ctr2) {
            this.areaComponents[ctr2] = new Vector();
        }
        this.highlightedTextAreas = new Vector();
        String tempString = TConfigurationManager.getProperty(CURRENT_DIRECTORY_KEY);
        if (tempString != null && (tempFile = new File(tempString)).isDirectory() && tempFile.canRead()) {
            this.currentDirectory = tempFile;
        }
        this.fileHistory = new File[6];
        int historyCtr = 0;
        for (int ctr3 = 0; ctr3 < 6; ++ctr3) {
            File tempFile2;
            String tempString2 = TConfigurationManager.getProperty(FILE_HISTORY_KEYS[ctr3]);
            if (tempString2 == null || !(tempFile2 = new File(tempString2)).isFile() || !tempFile2.canRead()) continue;
            this.fileHistory[historyCtr] = tempFile2;
            FILE_HISTORY_ACTIONS[historyCtr].setEnabled(true);
            FILE_HISTORY_ACTIONS[historyCtr].putValue("Name", tempFile2.getName());
            ++historyCtr;
        }
        tempString = TConfigurationManager.getProperty(LAST_FRAME_BOUNDS_KEY);
        if (tempString != null && tempString.startsWith("(") && tempString.endsWith(")")) {
            int commaIndex1 = tempString.indexOf(",");
            int commaIndex2 = tempString.indexOf(",", commaIndex1 + 1);
            int commaIndex3 = tempString.indexOf(",", commaIndex2 + 2);
            if (commaIndex1 != -1 && commaIndex2 != -1 && commaIndex3 != -1) {
                try {
                    this.lastFrameBounds = new Rectangle(Integer.parseInt(tempString.substring(1, commaIndex1)), Integer.parseInt(tempString.substring(commaIndex1 + 1, commaIndex2)), Integer.parseInt(tempString.substring(commaIndex2 + 1, commaIndex3)), Integer.parseInt(tempString.substring(commaIndex3 + 1, tempString.length() - 1)));
                    if (this.lastFrameBounds.width > TOptionsFrame.INITIAL_SCREEN_SIZE.width) {
                        this.lastFrameBounds.width = TOptionsFrame.INITIAL_SCREEN_SIZE.width;
                    }
                    if (this.lastFrameBounds.width < 112) {
                        this.lastFrameBounds.width = 112;
                    }
                    if (this.lastFrameBounds.height > TOptionsFrame.INITIAL_SCREEN_SIZE.height) {
                        this.lastFrameBounds.height = TOptionsFrame.INITIAL_SCREEN_SIZE.height;
                    }
                    if (this.lastFrameBounds.height < 27) {
                        this.lastFrameBounds.height = 27;
                    }
                    if (this.lastFrameBounds.x < 0) {
                        this.lastFrameBounds.x = 0;
                    }
                    if (this.lastFrameBounds.x + this.lastFrameBounds.width > TOptionsFrame.INITIAL_SCREEN_SIZE.width) {
                        this.lastFrameBounds.x = TOptionsFrame.INITIAL_SCREEN_SIZE.width - this.lastFrameBounds.width;
                    }
                    if (this.lastFrameBounds.y < 0) {
                        this.lastFrameBounds.y = 0;
                    }
                    if (this.lastFrameBounds.y + this.lastFrameBounds.height > TOptionsFrame.INITIAL_SCREEN_SIZE.height) {
                        this.lastFrameBounds.y = TOptionsFrame.INITIAL_SCREEN_SIZE.height - this.lastFrameBounds.height;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.lastFrameBounds == null) {
            this.lastFrameBounds = new Rectangle((Rectangle)DEFAULT_OPTIONS.get(LAST_FRAME_BOUNDS_KEY));
        }
        this.appliedOptions.put(LAST_FRAME_BOUNDS_KEY, this.lastFrameBounds);
        tempString = TConfigurationManager.getProperty(LAST_VERTICAL_DIVIDER_LOCATION_KEY);
        if (tempString != null) {
            try {
                this.lastVerticalDividerLocation = new IntStruct(Integer.parseInt(tempString));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.lastVerticalDividerLocation == null) {
            this.lastVerticalDividerLocation = new IntStruct((IntStruct)DEFAULT_OPTIONS.get(LAST_VERTICAL_DIVIDER_LOCATION_KEY));
        }
        this.appliedOptions.put(LAST_VERTICAL_DIVIDER_LOCATION_KEY, this.lastVerticalDividerLocation);
        tempString = TConfigurationManager.getProperty(LAST_EDIT_HORIZONTAL_DIVIDER_LOCATION_KEY);
        if (tempString != null) {
            try {
                this.lastEditHorizontalDividerLocation = new IntStruct(Integer.parseInt(tempString));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.lastEditHorizontalDividerLocation == null) {
            this.lastEditHorizontalDividerLocation = new IntStruct((IntStruct)DEFAULT_OPTIONS.get(LAST_EDIT_HORIZONTAL_DIVIDER_LOCATION_KEY));
        }
        this.appliedOptions.put(LAST_EDIT_HORIZONTAL_DIVIDER_LOCATION_KEY, this.lastEditHorizontalDividerLocation);
        tempString = TConfigurationManager.getProperty(LAST_SIM_HORIZONTAL_DIVIDER_LOCATION_KEY);
        if (tempString != null) {
            try {
                this.lastSimHorizontalDividerLocation = new IntStruct(Integer.parseInt(tempString));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.lastSimHorizontalDividerLocation == null) {
            this.lastSimHorizontalDividerLocation = new IntStruct((IntStruct)DEFAULT_OPTIONS.get(LAST_SIM_HORIZONTAL_DIVIDER_LOCATION_KEY));
        }
        this.appliedOptions.put(LAST_SIM_HORIZONTAL_DIVIDER_LOCATION_KEY, this.lastSimHorizontalDividerLocation);
        tempString = TConfigurationManager.getProperty(LAST_OPTIONS_FRAME_POSITION_KEY);
        if (tempString != null && tempString.startsWith("(") && tempString.endsWith(")") && (commaIndex = tempString.indexOf(",")) != -1) {
            try {
                this.lastOptionsFramePosition = new Point(Integer.parseInt(tempString.substring(1, commaIndex)), Integer.parseInt(tempString.substring(commaIndex + 1, tempString.length() - 1)));
                if (this.lastOptionsFramePosition.x < 0) {
                    this.lastOptionsFramePosition.x = 0;
                }
                if (this.lastOptionsFramePosition.x + 640 > TOptionsFrame.INITIAL_SCREEN_SIZE.width) {
                    this.lastOptionsFramePosition.x = TOptionsFrame.INITIAL_SCREEN_SIZE.width - 640;
                }
                if (this.lastOptionsFramePosition.y < 0) {
                    this.lastOptionsFramePosition.y = 0;
                }
                if (this.lastOptionsFramePosition.y + 460 > TOptionsFrame.INITIAL_SCREEN_SIZE.height) {
                    this.lastOptionsFramePosition.y = TOptionsFrame.INITIAL_SCREEN_SIZE.height - 460;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.lastOptionsFramePosition == null) {
            this.lastOptionsFramePosition = new Point((Point)DEFAULT_OPTIONS.get(LAST_OPTIONS_FRAME_POSITION_KEY));
        }
        this.appliedOptions.put(LAST_OPTIONS_FRAME_POSITION_KEY, this.lastOptionsFramePosition);
        for (ctr = 0; ctr < FONT_AREA_NAMES.length; ++ctr) {
            String tempString3 = TConfigurationManager.getProperty(FONT_AREA_KEYS[ctr]);
            if (tempString3 != null) {
                this.appliedOptions.put(FONT_AREA_KEYS[ctr], Font.decode(tempString3));
                continue;
            }
            this.appliedOptions.put(FONT_AREA_KEYS[ctr], DEFAULT_OPTIONS.get(FONT_AREA_KEYS[ctr]));
        }
        for (ctr = 0; ctr < COLOR_NAMES.length; ++ctr) {
            String tempString4 = TConfigurationManager.getProperty(COLOR_COLOR_KEYS[ctr]);
            if (tempString4 != null && tempString4.length() == 7 && tempString4.charAt(0) == '#' && TWord.isHexDigit(tempString4.charAt(1)) && TWord.isHexDigit(tempString4.charAt(2)) && TWord.isHexDigit(tempString4.charAt(3)) && TWord.isHexDigit(tempString4.charAt(4)) && TWord.isHexDigit(tempString4.charAt(5)) && TWord.isHexDigit(tempString4.charAt(6))) {
                this.appliedOptions.put(COLOR_COLOR_KEYS[ctr], new Color(16 * TWord.hexDigitToInt(tempString4.charAt(1)) + TWord.hexDigitToInt(tempString4.charAt(2)), 16 * TWord.hexDigitToInt(tempString4.charAt(3)) + TWord.hexDigitToInt(tempString4.charAt(4)), 16 * TWord.hexDigitToInt(tempString4.charAt(5)) + TWord.hexDigitToInt(tempString4.charAt(6))));
            } else {
                this.appliedOptions.put(COLOR_COLOR_KEYS[ctr], DEFAULT_OPTIONS.get(COLOR_COLOR_KEYS[ctr]));
            }
            tempString4 = TConfigurationManager.getProperty(COLOR_DISABLED_KEYS[ctr]);
            if ("true".equals(tempString4)) {
                this.appliedOptions.put(COLOR_DISABLED_KEYS[ctr], Boolean.TRUE);
                continue;
            }
            if ("false".equals(tempString4)) {
                this.appliedOptions.put(COLOR_DISABLED_KEYS[ctr], Boolean.FALSE);
                continue;
            }
            this.appliedOptions.put(COLOR_DISABLED_KEYS[ctr], DEFAULT_OPTIONS.get(COLOR_DISABLED_KEYS[ctr]));
        }
        for (ctr = 0; ctr < HIGHLIGHT_STYLE_NAMES.length; ++ctr) {
            String tempString5 = TConfigurationManager.getProperty(HIGHLIGHT_STYLE_KEYS[ctr]);
            HighlightStyle style = null;
            if (tempString5 != null) {
                style = HighlightStyle.parseStyle(tempString5);
            }
            if (style == null) {
                style = (HighlightStyle)DEFAULT_OPTIONS.get(HIGHLIGHT_STYLE_KEYS[ctr]);
            }
            this.appliedOptions.put(HIGHLIGHT_STYLE_KEYS[ctr], style);
        }
        this.appliedOptions.put(AUTO_COMPLETER_KEY, AUTO_COMPLETERS[2]);
        tempString = TConfigurationManager.getProperty(IGNORE_WARNINGS_KEY);
        if ("true".equals(tempString)) {
            this.appliedOptions.put(IGNORE_WARNINGS_KEY, Boolean.TRUE);
        } else if ("false".equals(tempString)) {
            this.appliedOptions.put(IGNORE_WARNINGS_KEY, Boolean.FALSE);
        } else {
            this.appliedOptions.put(IGNORE_WARNINGS_KEY, DEFAULT_OPTIONS.get(IGNORE_WARNINGS_KEY));
        }
        tempString = TConfigurationManager.getProperty(AUTO_CHECK_KEY);
        if ("true".equals(tempString)) {
            this.appliedOptions.put(AUTO_CHECK_KEY, Boolean.TRUE);
        } else if ("false".equals(tempString)) {
            this.appliedOptions.put(AUTO_CHECK_KEY, Boolean.FALSE);
        } else {
            this.appliedOptions.put(AUTO_CHECK_KEY, DEFAULT_OPTIONS.get(AUTO_CHECK_KEY));
        }
        for (int ctr4 = 0; ctr4 < EXCEPTION_TYPE_KEYS.length; ++ctr4) {
            String tempString6 = TConfigurationManager.getProperty(EXCEPTION_TYPE_KEYS[ctr4]);
            if ("true".equals(tempString6)) {
                this.appliedOptions.put(EXCEPTION_TYPE_KEYS[ctr4], Boolean.TRUE);
                continue;
            }
            if ("false".equals(tempString6)) {
                this.appliedOptions.put(EXCEPTION_TYPE_KEYS[ctr4], Boolean.FALSE);
                continue;
            }
            this.appliedOptions.put(EXCEPTION_TYPE_KEYS[ctr4], DEFAULT_OPTIONS.get(EXCEPTION_TYPE_KEYS[ctr4]));
        }
        tempString = TConfigurationManager.getProperty(CLOCK_PERIOD_KEY);
        if (tempString != null) {
            try {
                this.clockPeriod = new IntStruct(Integer.parseInt(tempString));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (this.clockPeriod == null) {
            this.clockPeriod = new IntStruct((IntStruct)DEFAULT_OPTIONS.get(CLOCK_PERIOD_KEY));
        }
        this.appliedOptions.put(CLOCK_PERIOD_KEY, this.clockPeriod);
        tempString = TConfigurationManager.getProperty(REFRESH_RATE_KEY);
        if (tempString != null) {
            try {
                this.refreshRate = new IntStruct(Integer.parseInt(tempString));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (this.refreshRate == null) {
            this.refreshRate = new IntStruct((IntStruct)DEFAULT_OPTIONS.get(REFRESH_RATE_KEY));
        }
        this.appliedOptions.put(REFRESH_RATE_KEY, this.refreshRate);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuBar.add(menu);
        menu.add(ClipboardTargetManager.CUT_ACTION.createMenuItem());
        menu.add(ClipboardTargetManager.COPY_ACTION.createMenuItem());
        menu.add(ClipboardTargetManager.PASTE_ACTION.createMenuItem());
        menu.addSeparator();
        menu.add(ClipboardTargetManager.SELECT_ALL_ACTION.createMenuItem());
        this.getContentPane().setLayout(new GridBagLayout());
        this.tree = new PTree(new DefaultTreeModel(ROOT_NODE, true));
        this.tree.setShowsRootHandles(true);
        this.tree.putClientProperty("PTree.lineStyle", "Angled");
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        for (int ctr5 = 0; ctr5 < this.tree.getRowCount(); ++ctr5) {
            this.tree.expandRow(ctr5);
        }
        this.getContentPane().add((Component)new JScrollPane(this.tree, 22, 30), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), this.tree.getPreferredSize().width, 0));
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        JPanel rootPane = new JPanel(new GridBagLayout());
        JTextArea textArea = new JTextArea();
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEnabled(false);
        textArea.setBackground(null);
        textArea.setDisabledTextColor(Color.black);
        textArea.setText("Visual X-TOY's Options Dialog allows users to edit its customizable features.  Changes to these preferences will be saved to the toy.conf file in the (located in the user's home directory) upon exit.\n\nIn this dialog you can configure settings ranging from the syntax highlighting styles to the kinds of exceptions that will be thrown in debug mode.\n\nSelect the subfolders for more detailed information about the options which can be configured here, or go straight to exploring those options.");
        textArea.setMargin(new Insets(2, 2, 2, 2));
        textArea.setBorder(new EtchedBorder());
        rootPane.add((Component)textArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 50, 2, 50), 0, 0));
        this.cardPanel.add((Component)rootPane, ROOT_NODE.toString());
        JPanel editingPane = new JPanel(new GridBagLayout());
        textArea = new JTextArea();
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEnabled(false);
        textArea.setBackground(null);
        textArea.setDisabledTextColor(Color.black);
        textArea.setText("The 'Editing' options configure the look and feel of the TOY program text area:\n\nIn the 'Fonts' section, you can configure the fonts used in certain parts of Visual X-TOY.\n\nIn the 'Colors' section, you can configure the colors of all the objects in the program text area with the exception of the syntactical structures.\n\nThe 'Syntax Highlighting' section allows you to pick the colors and styles (eg. bold) of the syntactical structures of the program text area.\n\n");
        textArea.setMargin(new Insets(2, 2, 2, 2));
        textArea.setBorder(new EtchedBorder());
        editingPane.add((Component)textArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 50, 2, 50), 0, 0));
        this.cardPanel.add((Component)editingPane, EDITING_NODE.toString());
        this.editingFontsPane = new TFontChooserPane(FONT_AREA_NAMES);
        this.cardPanel.add((Component)this.editingFontsPane, EDITING_FONTS_NODE.toString());
        this.editingColorsPane = new TColorChooserPane(COLOR_NAMES, COLOR_DISABLED_DESCRIPTIONS);
        this.cardPanel.add((Component)this.editingColorsPane, EDITING_COLORS_NODE.toString());
        this.editingHighlightingPane = new TStyleChooserPane(HIGHLIGHT_STYLE_NAMES);
        this.cardPanel.add((Component)this.editingHighlightingPane, EDITING_HIGHLIGHTING_NODE.toString());
        this.editingCheckingPane = new TCheckingChooserPane();
        this.cardPanel.add((Component)this.editingCheckingPane, EDITING_CHECKING_NODE.toString());
        JPanel executionPane = new JPanel(new GridBagLayout());
        textArea = new JTextArea();
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEnabled(false);
        textArea.setBackground(null);
        textArea.setDisabledTextColor(Color.black);
        textArea.setText("The 'Execution' options configure the way toy programs are run in both Debug and Sim mode.\n\nIn the 'Exception Handling' section, you can configure the TOY virtual machine to ignore certain exceptional conditions in Debug mode.  In Sim mode, all exceptional conditions are ignored and handled as the actual TOY machine would handle them.\n\nThe 'Performance' section allows you to configure how fast the TOY virtual machine will run and how often the window's display is refreshed during execution.");
        textArea.setMargin(new Insets(2, 2, 2, 2));
        textArea.setBorder(new EtchedBorder());
        executionPane.add((Component)textArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 50, 2, 50), 0, 0));
        this.cardPanel.add((Component)executionPane, EXECUTION_NODE.toString());
        this.executionExceptionPane = new TExceptionChooserPane();
        this.cardPanel.add((Component)this.executionExceptionPane, EXECUTION_EXCEPTION_NODE.toString());
        this.executionPerformancePane = new TPerformanceChooserPane(CLOCK_PERIODS, REFRESH_RATES);
        this.cardPanel.add((Component)this.executionPerformancePane, EXECUTION_PERFORMANCE_NODE.toString());
        this.getContentPane().add((Component)this.cardPanel, new GridBagConstraints(1, 0, 1, 1, 2.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 100));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 4, 4, 0));
        JButton button = new JButton("OK");
        button.setActionCommand(OK_COMMAND);
        button.addActionListener(this);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.setActionCommand(CANCEL_COMMAND);
        button.addActionListener(this);
        buttonPanel.add(button);
        button = new JButton("Apply");
        button.setActionCommand(APPLY_COMMAND);
        button.addActionListener(this);
        buttonPanel.add(button);
        button = new JButton("Defaults");
        button.setActionCommand(DEFAULTS_COMMAND);
        button.addActionListener(this);
        buttonPanel.add(button);
        this.getContentPane().add((Component)buttonPanel, new GridBagConstraints(0, 1, 2, 1, 3.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.setBounds(this.lastOptionsFramePosition.x, this.lastOptionsFramePosition.y, 640, 460);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.enableEvents(65L);
        this.setComponentState(this.appliedOptions);
        this.doCommand(APPLY_COMMAND, null);
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHook()));
    }

    @Override
    public void dispose() {
        this.doCommand(CANCEL_COMMAND, null);
    }

    public static void show(DefaultMutableTreeNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        TOptionsFrame.INSTANCE.tree.setSelectionPath(new TreePath(node.getPath()));
        INSTANCE.setVisible(true);
        INSTANCE.toFront();
    }

    public static void registerComponent(Component component, int areaIndex) {
        if (component == null) {
            throw new NullPointerException();
        }
        TOptionsFrame.INSTANCE.areaComponents[areaIndex].add(component);
        component.setFont((Font)TOptionsFrame.INSTANCE.appliedOptions.get(FONT_AREA_KEYS[areaIndex]));
    }

    public static void unregisterComponent(Component component, int areaIndex) {
        if (component == null) {
            throw new NullPointerException();
        }
        TOptionsFrame.INSTANCE.areaComponents[areaIndex].remove(component);
    }

    public static void registerHighlightedTextArea(PHighlightedTextArea textArea) {
        if (textArea == null) {
            throw new NullPointerException();
        }
        TOptionsFrame.INSTANCE.highlightedTextAreas.add(textArea);
        Hashtable appliedOptions = TOptionsFrame.INSTANCE.appliedOptions;
        boolean disabled = (Boolean)appliedOptions.get(COLOR_DISABLED_KEYS[0]);
        Color color = (Color)appliedOptions.get(COLOR_COLOR_KEYS[0]);
        textArea.setForeground(disabled ? Color.black : color);
        disabled = (Boolean)appliedOptions.get(COLOR_DISABLED_KEYS[1]);
        color = (Color)appliedOptions.get(COLOR_COLOR_KEYS[1]);
        textArea.setBackground(disabled ? Color.white : color);
        disabled = (Boolean)appliedOptions.get(COLOR_DISABLED_KEYS[2]);
        color = (Color)appliedOptions.get(COLOR_COLOR_KEYS[2]);
        textArea.setCaretColor(disabled ? null : color);
        disabled = (Boolean)appliedOptions.get(COLOR_DISABLED_KEYS[3]);
        color = (Color)appliedOptions.get(COLOR_COLOR_KEYS[3]);
        textArea.setSelectionColor(disabled ? null : color);
        disabled = (Boolean)appliedOptions.get(COLOR_DISABLED_KEYS[4]);
        color = (Color)appliedOptions.get(COLOR_COLOR_KEYS[4]);
        textArea.setSelectedTextColor(disabled ? null : color);
        disabled = (Boolean)appliedOptions.get(COLOR_DISABLED_KEYS[5]);
        color = (Color)appliedOptions.get(COLOR_COLOR_KEYS[5]);
        if (!disabled) {
            textArea.setHighlightColor(color);
            if (textArea.getHighlightedLine() == -1) {
                textArea.setHighlightedLine(-3);
            }
        } else if (textArea.getHighlightedLine() == -3) {
            textArea.setHighlightedLine(-1);
        }
        disabled = (Boolean)appliedOptions.get(COLOR_DISABLED_KEYS[6]);
        color = (Color)appliedOptions.get(COLOR_COLOR_KEYS[6]);
        textArea.setHighlightedTextColor(disabled ? null : color);
        disabled = (Boolean)appliedOptions.get(COLOR_DISABLED_KEYS[7]);
        color = (Color)appliedOptions.get(COLOR_COLOR_KEYS[7]);
        if (!disabled) {
            textArea.setShowLineNumbers(true);
            textArea.setLineNumberColor(color);
        } else {
            textArea.setShowLineNumbers(false);
        }
        disabled = (Boolean)appliedOptions.get(COLOR_DISABLED_KEYS[8]);
        color = (Color)appliedOptions.get(COLOR_COLOR_KEYS[8]);
        textArea.setMarkerColor(disabled ? null : color);
        for (int ctr = 0; ctr < HIGHLIGHT_STYLE_NAMES.length; ctr = (int)((byte)(ctr + 1))) {
            textArea.setStyle((HighlightStyle)appliedOptions.get(HIGHLIGHT_STYLE_KEYS[ctr]), ctr);
        }
        textArea.setAutoCompleter((AutoCompleter)appliedOptions.get(AUTO_COMPLETER_KEY));
    }

    public static void unregisterHighlightedTextArea(PHighlightedTextArea textArea) {
        if (textArea == null) {
            throw new NullPointerException();
        }
        TOptionsFrame.INSTANCE.highlightedTextAreas.remove(textArea);
    }

    public static TExceptionHandler getExceptionHandler() {
        return TOptionsFrame.INSTANCE.exceptionHandler;
    }

    public static int getClockPeriod() {
        return TOptionsFrame.INSTANCE.clockPeriod.value;
    }

    public static Document getClockPeriodDocument() {
        return TOptionsFrame.INSTANCE.clockPeriodDocument;
    }

    public static int getRefreshRate() {
        return TOptionsFrame.INSTANCE.refreshRate.value;
    }

    public static Document getRefreshRateDocument() {
        return TOptionsFrame.INSTANCE.refreshRateDocument;
    }

    public static boolean getIgnoreWarnings() {
        return TOptionsFrame.INSTANCE.ignoreWarnings;
    }

    public static boolean getAutoCheck() {
        return TOptionsFrame.INSTANCE.autoCheck;
    }

    public static File getCurrentDirectory() {
        return TOptionsFrame.INSTANCE.currentDirectory;
    }

    public static void setCurrentDirectory(File currentDirectory) {
        if (currentDirectory.canRead() && currentDirectory.isDirectory()) {
            TOptionsFrame.INSTANCE.currentDirectory = currentDirectory;
        }
    }

    public static File getFileFromHistory(int index) {
        return TOptionsFrame.INSTANCE.fileHistory[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void putFileIntoHistory(File file) {
        File[] fileHistory;
        if (!file.canRead() || !file.isFile()) return;
        File[] fileArray = fileHistory = TOptionsFrame.INSTANCE.fileHistory;
        synchronized (fileHistory) {
            int ctr;
            int oldIndex = 5;
            for (ctr = 0; ctr < 6 && fileHistory[ctr] != null; ++ctr) {
                if (!fileHistory[ctr].getName().equals(file.getName())) continue;
                oldIndex = ctr;
            }
            for (ctr = oldIndex; ctr > 0; --ctr) {
                fileHistory[ctr] = fileHistory[ctr - 1];
            }
            fileHistory[0] = file;
            for (ctr = 0; ctr < 6; ++ctr) {
                if (fileHistory[ctr] == null) {
                    FILE_HISTORY_ACTIONS[ctr].setEnabled(false);
                    FILE_HISTORY_ACTIONS[ctr].putValue("Name", "Recent File " + ctr);
                    continue;
                }
                FILE_HISTORY_ACTIONS[ctr].setEnabled(true);
                FILE_HISTORY_ACTIONS[ctr].putValue("Name", fileHistory[ctr].getName());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void setLastFrameBounds(Rectangle bounds) {
        TOptionsFrame.INSTANCE.lastFrameBounds.x = bounds.x;
        TOptionsFrame.INSTANCE.lastFrameBounds.y = bounds.y;
        TOptionsFrame.INSTANCE.lastFrameBounds.width = bounds.width;
        TOptionsFrame.INSTANCE.lastFrameBounds.height = bounds.height;
    }

    public static Rectangle getLastFrameBounds() {
        return new Rectangle(TOptionsFrame.INSTANCE.lastFrameBounds);
    }

    public static void setLastVerticalDividerLocation(int location) {
        TOptionsFrame.INSTANCE.lastVerticalDividerLocation.value = location;
    }

    public static int getLastVerticalDividerLocation() {
        return TOptionsFrame.INSTANCE.lastVerticalDividerLocation.value;
    }

    public static void setLastEditHorizontalDividerLocation(int location) {
        TOptionsFrame.INSTANCE.lastEditHorizontalDividerLocation.value = location;
    }

    public static int getLastEditHorizontalDividerLocation() {
        return TOptionsFrame.INSTANCE.lastEditHorizontalDividerLocation.value;
    }

    public static void setLastSimHorizontalDividerLocation(int location) {
        TOptionsFrame.INSTANCE.lastSimHorizontalDividerLocation.value = location;
    }

    public static int getLastSimHorizontalDividerLocation() {
        return TOptionsFrame.INSTANCE.lastSimHorizontalDividerLocation.value;
    }

    private void setComponentState(Hashtable options) {
        Object value;
        int ctr;
        for (ctr = 0; ctr < FONT_AREA_NAMES.length; ++ctr) {
            value = options.get(FONT_AREA_KEYS[ctr]);
            if (value == null) continue;
            this.editingFontsPane.setFont((Font)value, ctr);
        }
        for (ctr = 0; ctr < COLOR_NAMES.length; ++ctr) {
            value = options.get(COLOR_COLOR_KEYS[ctr]);
            if (value != null) {
                this.editingColorsPane.setColor((Color)value, ctr);
            }
            if ((value = options.get(COLOR_DISABLED_KEYS[ctr])) == null) continue;
            this.editingColorsPane.setDisabled((Boolean)value, ctr);
        }
        for (ctr = 0; ctr < HIGHLIGHT_STYLE_NAMES.length; ctr = (int)((byte)(ctr + 1))) {
            value = options.get(HIGHLIGHT_STYLE_KEYS[ctr]);
            if (value == null) continue;
            this.editingHighlightingPane.setStyle((HighlightStyle)value, ctr);
        }
        Object value2 = options.get(IGNORE_WARNINGS_KEY);
        if (value2 != null) {
            this.editingCheckingPane.setIgnoreWarnings((Boolean)value2);
        }
        if ((value2 = options.get(AUTO_CHECK_KEY)) != null) {
            this.editingCheckingPane.setAutoCheck((Boolean)value2);
        }
        for (int ctr2 = 0; ctr2 < EXCEPTION_TYPE_KEYS.length; ctr2 = (int)((byte)(ctr2 + 1))) {
            value = options.get(EXCEPTION_TYPE_KEYS[ctr2]);
            if (value == null) continue;
            this.executionExceptionPane.setWillThrow(ctr2, (Boolean)value);
        }
        value = options.get(CLOCK_PERIOD_KEY);
        if (value != null) {
            this.executionPerformancePane.setClockPeriod(((IntStruct)value).value);
        }
        if ((value = options.get(REFRESH_RATE_KEY)) != null) {
            this.executionPerformancePane.setRefreshRate(((IntStruct)value).value);
        }
    }

    public boolean doCommand(String command, Object extraInfo) {
        if (command == OK_COMMAND) {
            this.doCommand(APPLY_COMMAND, null);
            this.setVisible(false);
            return true;
        }
        if (command == CANCEL_COMMAND) {
            this.setComponentState(this.appliedOptions);
            this.setVisible(false);
            return true;
        }
        if (command == APPLY_COMMAND) {
            int ctr2;
            int length;
            Object[] array;
            int ctr;
            for (ctr = 0; ctr < FONT_AREA_NAMES.length; ++ctr) {
                Font font = this.editingFontsPane.getFont(ctr);
                this.appliedOptions.put(FONT_AREA_KEYS[ctr], font);
                array = this.areaComponents[ctr].toArray();
                length = array.length;
                for (ctr2 = 0; ctr2 < length; ++ctr2) {
                    ((Component)array[ctr2]).setFont(font);
                }
            }
            array = this.highlightedTextAreas.toArray();
            length = array.length;
            block17: for (ctr = 0; ctr < COLOR_NAMES.length; ++ctr) {
                Color color = this.editingColorsPane.getColor(ctr);
                boolean disabled = this.editingColorsPane.isDisabled(ctr);
                this.appliedOptions.put(COLOR_COLOR_KEYS[ctr], color);
                this.appliedOptions.put(COLOR_DISABLED_KEYS[ctr], disabled ? Boolean.TRUE : Boolean.FALSE);
                switch (ctr) {
                    case 0: {
                        int ctr22;
                        for (ctr22 = 0; ctr22 < length; ++ctr22) {
                            ((PHighlightedTextArea)array[ctr22]).setForeground(disabled ? Color.black : color);
                        }
                        continue block17;
                    }
                    case 1: {
                        int ctr22;
                        for (ctr22 = 0; ctr22 < length; ++ctr22) {
                            ((PHighlightedTextArea)array[ctr22]).setBackground(disabled ? Color.white : color);
                        }
                        continue block17;
                    }
                    case 2: {
                        int ctr22;
                        for (ctr22 = 0; ctr22 < length; ++ctr22) {
                            ((PHighlightedTextArea)array[ctr22]).setCaretColor(disabled ? null : color);
                        }
                        continue block17;
                    }
                    case 3: {
                        int ctr22;
                        for (ctr22 = 0; ctr22 < length; ++ctr22) {
                            ((PHighlightedTextArea)array[ctr22]).setSelectionColor(disabled ? null : color);
                        }
                        continue block17;
                    }
                    case 4: {
                        int ctr22;
                        for (ctr22 = 0; ctr22 < length; ++ctr22) {
                            ((PHighlightedTextArea)array[ctr22]).setSelectedTextColor(disabled ? null : color);
                        }
                        continue block17;
                    }
                    case 5: {
                        PHighlightedTextArea textArea;
                        int ctr22;
                        if (!disabled) {
                            for (ctr22 = 0; ctr22 < length; ++ctr22) {
                                textArea = (PHighlightedTextArea)array[ctr22];
                                textArea.setHighlightColor(color);
                                if (textArea.getHighlightedLine() != -1) continue;
                                textArea.setHighlightedLine(-3);
                            }
                            continue block17;
                        }
                        for (ctr22 = 0; ctr22 < length; ++ctr22) {
                            textArea = (PHighlightedTextArea)array[ctr22];
                            if (textArea.getHighlightedLine() != -3) continue;
                            textArea.setHighlightedLine(-1);
                        }
                        continue block17;
                    }
                    case 6: {
                        int ctr22;
                        for (ctr22 = 0; ctr22 < length; ++ctr22) {
                            ((PHighlightedTextArea)array[ctr22]).setHighlightedTextColor(disabled ? null : color);
                        }
                        continue block17;
                    }
                    case 7: {
                        PHighlightedTextArea textArea;
                        int ctr22;
                        if (!disabled) {
                            for (ctr22 = 0; ctr22 < length; ++ctr22) {
                                textArea = (PHighlightedTextArea)array[ctr22];
                                textArea.setShowLineNumbers(true);
                                textArea.setLineNumberColor(color);
                            }
                            continue block17;
                        }
                        for (ctr22 = 0; ctr22 < length; ++ctr22) {
                            ((PHighlightedTextArea)array[ctr22]).setShowLineNumbers(false);
                        }
                        continue block17;
                    }
                    case 8: {
                        int ctr22;
                        for (ctr22 = 0; ctr22 < length; ++ctr22) {
                            ((PHighlightedTextArea)array[ctr22]).setMarkerColor(disabled ? null : color);
                        }
                        continue block17;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            for (ctr = 0; ctr < HIGHLIGHT_STYLE_NAMES.length; ctr = (int)((byte)(ctr + 1))) {
                HighlightStyle style = this.editingHighlightingPane.getStyle(ctr);
                this.appliedOptions.put(HIGHLIGHT_STYLE_KEYS[ctr], style);
                for (ctr2 = 0; ctr2 < length; ++ctr2) {
                    ((PHighlightedTextArea)array[ctr2]).setStyle(style, ctr);
                }
            }
            this.appliedOptions.put(AUTO_COMPLETER_KEY, AUTO_COMPLETERS[2]);
            for (int ctr23 = 0; ctr23 < length; ++ctr23) {
                ((PHighlightedTextArea)array[ctr23]).setAutoCompleter(AUTO_COMPLETERS[2]);
            }
            this.ignoreWarnings = this.editingCheckingPane.getIgnoreWarnings();
            this.appliedOptions.put(IGNORE_WARNINGS_KEY, this.ignoreWarnings ? Boolean.TRUE : Boolean.FALSE);
            this.autoCheck = this.editingCheckingPane.getAutoCheck();
            TFrame.setAutoCheck(this.autoCheck);
            this.appliedOptions.put(AUTO_CHECK_KEY, this.autoCheck ? Boolean.TRUE : Boolean.FALSE);
            for (ctr = 0; ctr < EXCEPTION_TYPE_KEYS.length; ctr = (int)((byte)(ctr + 1))) {
                boolean willThrow = this.executionExceptionPane.getWillThrow(ctr);
                this.appliedOptions.put(EXCEPTION_TYPE_KEYS[ctr], willThrow ? Boolean.TRUE : Boolean.FALSE);
                this.exceptionHandler.setWillThrow(ctr, willThrow);
            }
            this.clockPeriod.value = this.executionPerformancePane.getClockPeriod();
            try {
                this.clockPeriodDocument.remove(0, this.clockPeriodDocument.getLength());
                this.clockPeriodDocument.insertString(0, this.clockPeriod + " ms", null);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.refreshRate.value = this.executionPerformancePane.getRefreshRate();
            try {
                this.refreshRateDocument.remove(0, this.refreshRateDocument.getLength());
                this.refreshRateDocument.insertString(0, this.refreshRate + " spr", null);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            return true;
        }
        if (command == DEFAULTS_COMMAND) {
            this.setComponentState(DEFAULT_OPTIONS);
            return true;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doCommand(e.getActionCommand(), null);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        if (path != null) {
            this.cardLayout.show(this.cardPanel, path.getLastPathComponent().toString());
        }
    }

    @Override
    protected void processComponentEvent(ComponentEvent e) {
        if (e.getID() == 100) {
            this.lastOptionsFramePosition.x = this.getX();
            this.lastOptionsFramePosition.y = this.getY();
        }
        super.processComponentEvent(e);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.doCommand(CANCEL_COMMAND, null);
        }
        super.processWindowEvent(e);
    }

    static {
        int ctr;
        CLASS_STRING = TOptionsFrame.class.toString();
        OK_COMMAND = CLASS_STRING + "#okCommand";
        CANCEL_COMMAND = CLASS_STRING + "#cancelCommand";
        DEFAULTS_COMMAND = CLASS_STRING + "#defaultsCommand";
        APPLY_COMMAND = CLASS_STRING + "#applyCommand";
        ROOT_NODE = new DefaultMutableTreeNode("Visual X-TOY Options", true);
        EDITING_NODE = new DefaultMutableTreeNode("Editing", true);
        EDITING_FONTS_NODE = new DefaultMutableTreeNode("Fonts", false);
        EDITING_COLORS_NODE = new DefaultMutableTreeNode("Colors", false);
        EDITING_HIGHLIGHTING_NODE = new DefaultMutableTreeNode("Syntax Highlighting", false);
        EDITING_CHECKING_NODE = new DefaultMutableTreeNode("Syntax Checking", false);
        EXECUTION_NODE = new DefaultMutableTreeNode("Execution", true);
        EXECUTION_EXCEPTION_NODE = new DefaultMutableTreeNode("Exception Handling", false);
        EXECUTION_PERFORMANCE_NODE = new DefaultMutableTreeNode("Performance", false);
        FONT_AREA_NAMES = new String[]{"Program Text Area", "Warning List", "Reference Panel", "Stdin Panel", "Stdout Panel", "Core Panel"};
        FONT_AREA_KEYS = new String[]{"toy.editing.fonts#programTextAreaFont", "toy.editing.fonts#warningListFont", "toy.editing.fonts#referencePanelFont", "toy.editing.fonts#stdinPanelFont", "toy.editing.fonts#stdoutPanelFont", "toy.editing.fonts#corePanelFont"};
        COLOR_NAMES = new String[]{"Foreground", "Background", "Caret", "Selection", "Selected Text", "Highlighted Line", "Highlighted Text", "Line Numbers", "Column Markers"};
        COLOR_DISABLED_DESCRIPTIONS = new String[]{"Use default", "Use default", "Use foreground", "Don't paint", "Same as normal text", "Don't paint", "Same as normal text", "Don't show", "Don't paint"};
        COLOR_COLOR_KEYS = new String[]{"toy.editing.colors.foreground#color", "toy.editing.colors.background#color", "toy.editing.colors.caret#color", "toy.editing.colors.selection#color", "toy.editing.colors.selectedText#color", "toy.editing.colors.highlightedLine#color", "toy.editing.colors.highlightedText#color", "toy.editing.colors.lineNumbers#color", "toy.editing.colors.columnMarkers#color"};
        COLOR_DISABLED_KEYS = new String[]{"toy.editing.colors.foreground#disabled", "toy.editing.colors.background#disabled", "toy.editing.colors.caret#disabled", "toy.editing.colors.selection#disabled", "toy.editing.colors.selectedText#disabled", "toy.editing.colors.highlightedLine#disabled", "toy.editing.colors.highlightedText#disabled", "toy.editing.colors.lineNumbers#disabled", "toy.editing.colors.columnMarkers#disabled"};
        HIGHLIGHT_STYLE_NAMES = new String[]{"Identifier", "Instruction", "Keyword", "Comment", "Auto-Comment", "Outside Margin"};
        HIGHLIGHT_STYLE_KEYS = new String[]{"toy.editing.highlighting#identifier", "toy.editing.highlighting#instruction", "toy.editing.highlighting#keyword", "toy.editing.highlighting#comment", "toy.editing.highlighting#autoComment", "toy.editing.highlighting#outsideMargin"};
        AUTO_COMPLETERS = new AutoCompleter[]{new IndentingAutoCompleter(), new TUncommentingAutoCompleter(), new TCommentingAutoCompleter()};
        EXCEPTION_TYPE_KEYS = new String[]{"toy.execution.exceptionHandling#willThrowRegisterUninitialized", "toy.execution.exceptionHandling#willThrowMemoryUninitialized", "toy.execution.exceptionHandling#willThrowCommandUninitialized", "toy.execution.exceptionHandling#willThrowOverflow", "toy.execution.exceptionHandling#willThrowShiftOutOfBounds", "toy.execution.exceptionHandling#willThrowPcOutOfBounds", "toy.execution.exceptionHandling#willThrowRegisterOutOfBounds", "toy.execution.exceptionHandling#willThrowMemOutOfBounds"};
        CLOCK_PERIODS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 16, 20, 25, 32, 40, 50, 63, 80, 100, 120, 160, 200, 250, 320, 400, 500, 630, 800, 1000, 1200, 1600, 2000, 2500, 3200, 4000, 5000, 6300, 8000, 10000};
        REFRESH_RATES = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 16, 20, 25, 32, 40, 50, 63, 79, 100, 130, 160, 200, 250, 320, 400, 500, 630, 790, 1000, 1300, 1600, 2000, 2500, 3200, 4000, 5000, 6300, 7900, 10000};
        TOOLKIT = Toolkit.getDefaultToolkit();
        OPTIONS_ACTION = new OptionsAction();
        FILE_HISTORY_ACTIONS = new AbstractAction2[6];
        FILE_HISTORY_KEYS = new String[]{"toy.autogenerate.filesystem#fileHistory0", "toy.autogenerate.filesystem#fileHistory1", "toy.autogenerate.filesystem#fileHistory2", "toy.autogenerate.filesystem#fileHistory3", "toy.autogenerate.filesystem#fileHistory4", "toy.autogenerate.filesystem#fileHistory5"};
        NULL_OBJECT = new Object();
        DEFAULT_OPTIONS = new Hashtable();
        INITIAL_SCREEN_SIZE = TOOLKIT.getScreenSize();
        for (ctr = 0; ctr < 6; ++ctr) {
            TOptionsFrame.FILE_HISTORY_ACTIONS[ctr] = new FileHistoryAction(ctr);
        }
        ROOT_NODE.add(EDITING_NODE);
        EDITING_NODE.add(EDITING_FONTS_NODE);
        EDITING_NODE.add(EDITING_COLORS_NODE);
        EDITING_NODE.add(EDITING_HIGHLIGHTING_NODE);
        EDITING_NODE.add(EDITING_CHECKING_NODE);
        ROOT_NODE.add(EXECUTION_NODE);
        EXECUTION_NODE.add(EXECUTION_EXCEPTION_NODE);
        EXECUTION_NODE.add(EXECUTION_PERFORMANCE_NODE);
        DEFAULT_OPTIONS.put(FONT_AREA_KEYS[0], new Font("Monospaced", 0, 12));
        DEFAULT_OPTIONS.put(FONT_AREA_KEYS[1], new Font("SansSerif", 0, 12));
        DEFAULT_OPTIONS.put(FONT_AREA_KEYS[2], new Font("Monospaced", 0, 12));
        DEFAULT_OPTIONS.put(FONT_AREA_KEYS[3], new Font("Monospaced", 0, 12));
        DEFAULT_OPTIONS.put(FONT_AREA_KEYS[4], new Font("Monospaced", 0, 12));
        DEFAULT_OPTIONS.put(FONT_AREA_KEYS[5], new Font("Monospaced", 0, 12));
        DEFAULT_OPTIONS.put(COLOR_COLOR_KEYS[0], Color.black);
        DEFAULT_OPTIONS.put(COLOR_DISABLED_KEYS[0], Boolean.TRUE);
        DEFAULT_OPTIONS.put(COLOR_COLOR_KEYS[1], Color.white);
        DEFAULT_OPTIONS.put(COLOR_DISABLED_KEYS[1], Boolean.TRUE);
        DEFAULT_OPTIONS.put(COLOR_COLOR_KEYS[2], Color.black);
        DEFAULT_OPTIONS.put(COLOR_DISABLED_KEYS[2], Boolean.TRUE);
        DEFAULT_OPTIONS.put(COLOR_COLOR_KEYS[3], new Color(204, 204, 255));
        DEFAULT_OPTIONS.put(COLOR_DISABLED_KEYS[3], Boolean.FALSE);
        DEFAULT_OPTIONS.put(COLOR_COLOR_KEYS[4], Color.black);
        DEFAULT_OPTIONS.put(COLOR_DISABLED_KEYS[4], Boolean.TRUE);
        DEFAULT_OPTIONS.put(COLOR_COLOR_KEYS[5], new Color(186, 186, 255));
        DEFAULT_OPTIONS.put(COLOR_DISABLED_KEYS[5], Boolean.FALSE);
        DEFAULT_OPTIONS.put(COLOR_COLOR_KEYS[6], Color.black);
        DEFAULT_OPTIONS.put(COLOR_DISABLED_KEYS[6], Boolean.TRUE);
        DEFAULT_OPTIONS.put(COLOR_COLOR_KEYS[7], new Color(148, 148, 148));
        DEFAULT_OPTIONS.put(COLOR_DISABLED_KEYS[7], Boolean.FALSE);
        DEFAULT_OPTIONS.put(COLOR_COLOR_KEYS[8], new Color(206, 206, 206));
        DEFAULT_OPTIONS.put(COLOR_DISABLED_KEYS[8], Boolean.FALSE);
        DEFAULT_OPTIONS.put(HIGHLIGHT_STYLE_KEYS[0], new HighlightStyle(Color.black, false, false));
        DEFAULT_OPTIONS.put(HIGHLIGHT_STYLE_KEYS[1], new HighlightStyle(Color.blue, false, false));
        DEFAULT_OPTIONS.put(HIGHLIGHT_STYLE_KEYS[2], new HighlightStyle(Color.black, true, false));
        DEFAULT_OPTIONS.put(HIGHLIGHT_STYLE_KEYS[3], new HighlightStyle(new Color(0, 128, 0), false, false));
        DEFAULT_OPTIONS.put(HIGHLIGHT_STYLE_KEYS[4], new HighlightStyle(Color.black, false, false));
        DEFAULT_OPTIONS.put(HIGHLIGHT_STYLE_KEYS[5], new HighlightStyle(Color.red, false, false));
        DEFAULT_OPTIONS.put(IGNORE_WARNINGS_KEY, Boolean.FALSE);
        DEFAULT_OPTIONS.put(AUTO_CHECK_KEY, Boolean.FALSE);
        for (ctr = 0; ctr < EXCEPTION_TYPE_KEYS.length; ++ctr) {
            DEFAULT_OPTIONS.put(EXCEPTION_TYPE_KEYS[ctr], Boolean.TRUE);
        }
        DEFAULT_OPTIONS.put(CLOCK_PERIOD_KEY, new IntStruct(CLOCK_PERIODS[20]));
        DEFAULT_OPTIONS.put(REFRESH_RATE_KEY, new IntStruct(REFRESH_RATES[0]));
        DEFAULT_OPTIONS.put(LAST_FRAME_BOUNDS_KEY, new Rectangle(TOptionsFrame.INITIAL_SCREEN_SIZE.width / 20, TOptionsFrame.INITIAL_SCREEN_SIZE.height / 20, TOptionsFrame.INITIAL_SCREEN_SIZE.width * 9 / 10, TOptionsFrame.INITIAL_SCREEN_SIZE.height * 9 / 10));
        DEFAULT_OPTIONS.put(LAST_VERTICAL_DIVIDER_LOCATION_KEY, new IntStruct(-1));
        DEFAULT_OPTIONS.put(LAST_EDIT_HORIZONTAL_DIVIDER_LOCATION_KEY, new IntStruct(-1));
        DEFAULT_OPTIONS.put(LAST_SIM_HORIZONTAL_DIVIDER_LOCATION_KEY, new IntStruct(-1));
        DEFAULT_OPTIONS.put(LAST_OPTIONS_FRAME_POSITION_KEY, new Point((TOptionsFrame.INITIAL_SCREEN_SIZE.width - 640) / 2, (TOptionsFrame.INITIAL_SCREEN_SIZE.height - 460) / 2));
        INSTANCE = new TOptionsFrame();
    }

    protected class ShutdownHook
    implements Runnable {
        protected ShutdownHook() {
        }

        @Override
        public void run() {
            Hashtable<String, String> map = new Hashtable<String, String>();
            Object[] keys = TOptionsFrame.this.appliedOptions.keySet().toArray();
            for (int ctr = 0; ctr < keys.length; ++ctr) {
                Object value = TOptionsFrame.this.appliedOptions.get(keys[ctr]);
                if (value == NULL_OBJECT) {
                    map.put(keys[ctr].toString(), "null");
                    continue;
                }
                if (value instanceof Point) {
                    Point point = (Point)value;
                    map.put(keys[ctr].toString(), "(" + point.x + "," + point.y + ")");
                    continue;
                }
                if (value instanceof Rectangle) {
                    Rectangle rectangle = (Rectangle)value;
                    map.put(keys[ctr].toString(), "(" + rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height + ")");
                    continue;
                }
                if (value instanceof Font) {
                    Font font = (Font)value;
                    map.put(keys[ctr].toString(), font.getName() + "-" + (font.isBold() ? "BOLD" : "") + (font.isItalic() ? "ITALIC" : "") + "-" + font.getSize());
                    continue;
                }
                if (value instanceof Color) {
                    Color color = (Color)value;
                    map.put(keys[ctr].toString(), "#" + TWord.HEX_PAIRS[color.getRed()] + TWord.HEX_PAIRS[color.getGreen()] + TWord.HEX_PAIRS[color.getBlue()]);
                    continue;
                }
                map.put(keys[ctr].toString(), value.toString());
            }
            File tempFile = INSTANCE.currentDirectory;
            if (tempFile != null) {
                try {
                    map.put(TOptionsFrame.CURRENT_DIRECTORY_KEY, tempFile.getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    map.put(TOptionsFrame.CURRENT_DIRECTORY_KEY, tempFile.getAbsolutePath());
                }
            }
            int historyCtr = 0;
            for (int ctr = 0; ctr < 6; ++ctr) {
                tempFile = INSTANCE.fileHistory[ctr];
                if (tempFile == null) continue;
                try {
                    map.put(FILE_HISTORY_KEYS[historyCtr], tempFile.getCanonicalPath());
                    ++historyCtr;
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    map.put(FILE_HISTORY_KEYS[historyCtr], tempFile.getAbsolutePath());
                }
            }
            TConfigurationManager.exportProperties(map);
        }
    }

    protected static class FileHistoryAction
    extends AbstractAction2 {
        private int index;

        protected FileHistoryAction(int index) {
            super("Recent File " + index);
            if (index < 0 || index >= 6) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.index = index;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = INSTANCE.fileHistory[this.index];
            if (file == null) {
                return;
            }
            Component source = (Component)e.getSource();
            while (!(source instanceof TFrame)) {
                if (source instanceof JPopupMenu) {
                    source = ((JPopupMenu)source).getInvoker();
                    continue;
                }
                source = source.getParent();
            }
            ((TFrame)source).doCommand(TFrame.OPEN_COMMAND, file);
        }
    }

    protected static class OptionsAction
    extends AbstractAction2 {
        protected OptionsAction() {
            super("Options...");
            this.setMnemonic(79);
            this.setAccelerator(KeyStroke.getKeyStroke(79, TOOLKIT.getMenuShortcutKeyMask() | 1));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            INSTANCE.setVisible(true);
            INSTANCE.toFront();
        }
    }

    protected static class IntStruct {
        protected int value;

        protected IntStruct() {
            this(0);
        }

        protected IntStruct(IntStruct intStruct) {
            this(intStruct.value);
        }

        protected IntStruct(int value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

